// STLport config file for PalmSource's PalmOS (used with pacc and gcc)

#if __PALMOS__ >= 0x05000000 && __PALMOS__ < 0x06000000

/* Configuration for PalmOS 5.0/Garnet, set up for gcc-68k */

# define _STLP_NO_CSTD_FUNCTION_IMPORTS 1
# define _STLP_NO_WCHAR_T
# define _NOTHREADS
# define _STLP_NO_THREADS
# define _STLP_NO_NATIVE_MBSTATE_T      1
# define _STLP_NO_NATIVE_WIDE_STREAMS   1
# define _STLP_WCHAR_BORLAND_EXCLUDE
# define _STLP_NO_NATIVE_WIDE_FUNCTIONS 1
# define _STLP_USE_STDIO_IO 1
# define _STLP_NO_IOSTREAMS 1
# define _STLP_NO_OWN_IOSTREAMS 1
# define _STLP_USE_NEWALLOC 1
# undef _STLP_OWN_IOSTREAMS

#elif __PALMOS__ >= 0x06000000

/* Configuration for PalmOS 6.0/Cobalt, set up for pacc and gcc-x86 */

// compiler-specific stuff
# if defined(_PACC_VER)
#  define _STLP_NATIVE_C_HEADER(x) <##x##>
#  if !defined(__EXCEPTIONS)
#   define _STLP_NO_EXCEPTIONS 1
#  endif
# elif defined(__GNUC__)
#  undef _STLP_NATIVE_CPP_RUNTIME_INCLUDE_PATH 
#  undef _STLP_NATIVE_INCLUDE_PATH 
#  define _STLP_NATIVE_C_HEADER(x) <x>
#  define _STLP_NATIVE_CPP_C_HEADER(x) <x>
#  undef _STLP_USE_NEW_C_HEADERS
#  define _STLP_HAS_NO_NEW_C_HEADERS 1
#  define _STLP_NO_NEW_NEW_HEADER 1
#  undef _STLP_NO_NEW_NEW_HEADER
#  undef _STLP_NATIVE_OLD_STREAMS_INCLUDE_PATH 
#  undef  _STLP_NO_BAD_ALLOC
#  define _STLP_NATIVE_CPP_RUNTIME_HEADER(header) <../3.3.1/header>
# endif // compiler-specific

// Threading
# define _STLP_PALMOS6THREADS 1
# define _STLP_THREADS_DEFINED 1

// Wide-char stuff
# define _STLP_NO_NATIVE_WIDE_STREAMS 1
//#define _STLP_NO_WCHAR_T 1
//#define _STLP_NO_MBSTATE_T 1
# define _STLP_WCHAR_BORLAND_EXCLUDE 1

// Iostreams
# define _STLP_OWN_IOSTREAMS
# define _STLP_USE_STDIO_IO 1
# define _STLP_NO_STAT 1

// Namespace
# define _STLP_NO_OWN_NAMESPACE 1

// Allocation
# if !defined(_STLP_USE_NEWALLOC) && !defined(_STLP_USE_MALLOC)
// Use malloc unless somebody wanted something else
#  define _STLP_USE_MALLOC 1
# endif

// Other stuff

//#define _STLP_DEBUG 1

# define _STLP_LONG_LONG long long
# define _STLP_HAS_NO_NEW_C_HEADERS 1

# ifdef _PACC_VER
/* This really ought to be provided for both pacc & gcc, but
   we don't have this routine available in a library for gcc, yet.
 */

   extern 
#  ifdef __cplusplus
    "C" 
#  endif
    void __abort(const char*);
 // this is invoked if exceptions aren't enabled, and the throwing new fails
#  define __THROW_BAD_ALLOC __abort("new threw bad_alloc")
# endif

#endif /* __PALMOS__ */                                 
